using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace EQTrack
{
	
    public partial class LoginForm : Form
	{
		private bool StartingUp = true;
        public string CurrentUserName = "";
        public bool LoginPassed = false;
        public bool LoginFailed = false;

		public LoginForm()
		{
			InitializeComponent();
            Globals.LoginService.LoginCompleted += new EQTrack.BlackhawkLoginService.LoginCompletedEventHandler(LoginService_LoginCompleted);
            
             
			UsernameEdit.Text = Globals.Settings.GetString(Globals.SettingsPathLogin + "Username", "");
			PasswordEdit.Text = Globals.Settings.GetString(Globals.SettingsPathLogin + "Password", "");
			RememberMeCheckbox.Checked = Globals.Settings.GetBool(Globals.SettingsPathLogin + "RememberMe", false);
		}

		private void MainPanel_OnInitialise(object sender, EventArgs e)
		{
            
            if (!RememberMeCheckbox.Checked)
				PasswordEdit.Text = "";
			UsernameEdit.SelectAll();
			UsernameEdit.Focus();

			if (StartingUp)
			{
				StartingUp = false;
				if (RememberMeCheckbox.Checked)
					LoginButton_Click(null, null);
			}
		}

        void LoginService_LoginCompleted(object sender, EQTrack.BlackhawkLoginService.LoginCompletedEventArgs e)
        {
            LoginPassed = true;
        }

		public new void Dispose()
		{
			Globals.Settings.Set(Globals.SettingsPathLogin + "Username", UsernameEdit.Text);
			Globals.Settings.Set(Globals.SettingsPathLogin + "Password", RememberMeCheckbox.Checked ? PasswordEdit.Text : "");
			Globals.Settings.Set(Globals.SettingsPathLogin + "RememberMe", RememberMeCheckbox.Checked);
		}

		private void LoginButton_Click(object sender, EventArgs e)
		{
			if (UsernameEdit.Text.Trim() == "")
				MessageBox.Show(Globals.MainForm, "Please enter a Username.", "Error!", MessageBoxButtons.OK, MessageBoxIcon.Error);
			else
			{
				MainPanel.Cursor = Cursors.WaitCursor;
				UsernameEdit.Enabled = false;
				PasswordEdit.Enabled = false;
				RememberMeCheckbox.Enabled = false;
				LoginButton.Enabled = false;
                Globals.UserName = UsernameEdit.Text.Trim();   
				MainPanel.Update();
				try
				{
                    LoginPassed = Globals.LoginService.Login (UsernameEdit.Text.Trim(), PasswordEdit.Text.Trim());
                    if (LoginPassed == true)
                    {
						Globals.MainForm.AnimateDirectionLeft = true;
                        Globals.CustomerID = Globals.AdminService.GetDeviceSetID(Globals.UserName);   
                        CurrentUserName =  UsernameEdit.Text.Trim();
                      //  Globals.MainMenuForm.PopulateTest();
						Globals.MainForm.CurrentPanel = Globals.MainMenuForm.MainPanel;
                        Globals.MainMenuForm.setFocus();
					}
					else
					{
						MessageBox.Show(Globals.MainForm, "You have entered an invalid Username or Password.", "Log In Failed!", MessageBoxButtons.OK, MessageBoxIcon.Error);
					}
				}
				catch (Exception err)
				{
					MessageBox.Show(Globals.MainForm, "An error occurred while attempting to log in to the Blackhawk Server.\n\n" + err.Message, "Error!", MessageBoxButtons.OK, MessageBoxIcon.Error);
				}
				UsernameEdit.Enabled = true;
				PasswordEdit.Enabled = true;
				RememberMeCheckbox.Enabled = true;
				LoginButton.Enabled = true;
				MainPanel.Cursor = Cursors.Default;
			}
		}

		private void UsernameEdit_KeyPress(object sender, KeyPressEventArgs e)
		{
			if (e.KeyChar == 13)
				LoginButton_Click(null, null);
		}

	}
}